' SwissDecTX Transmitter (c) 2009 Axel Rietschin Software Developments http://www.softwarecomponents.ch
'
'This script must be run with the following command:
'
'    c:\Windows\System32\cscript Hello.vbs
'
' On 64-bit machines, use
'
'    c:\Windows\SYSWOW64\cscript Hello.vbs
'
' This script makes no error checking at all and assumes that the
' SwissDecTX transmitter is already installed and properly configured
'
' The Microsoft XML Parser 6.0 must be installed!
'
' This sample demonstrate the use of the SwissDecTX.Transmitter class

wscript.Echo "Creating SwissDecTX.Transmitter object..."

Set tx = CreateObject("SwissDecTX.Transmitter")

' Ping the server

wscript.Echo "Ping..."

tx.Ping

' Perform a full interoperability check

wscript.Echo "Check interoperability..."

tx.CheckInteroperability "tester" ' use your own monitoring ID instead of "tester"

' Send a salary declaration

wscript.Echo "Send declaration..."

Dim jobFinished, transmissionDateTime
tx.File2FileDeclareSalary "ICHAGCompany2008.xml", "result.xml", "messageSent.xml", "messageReceived.xml", "plausibility.xml", jobFinished, transmissionDateTime
Set tx = Nothing

' Format the plausibility result as HTML for display

wscript.Echo "Format result..."

Set xslt = CreateObject("SwissDecTX.TransmitterUtilities")
xslt.ConvertFromFilesToFile "plausibility.xml", Nothing, "plausibility.html"
Set xslt = Nothing

' Lauch the default browser on the formatted plausibility result

wscript.Echo "Display result in default browser..."

Set shell = WScript.CreateObject("WScript.Shell")
shell.Run "plausibility.html", 1, false
Set shell = Nothing

wscript.Echo "Done."
