' SwissDecTX Transmitter (c) 2009 Axel Rietschin Software Developments http://www.softwarecomponents.ch
'
'This script must be launched with the following command:
'
'    c:\Windows\System32\cscript Hello.vbs
'
' On 64-bit machines, use
'
'    c:\Windows\SYSWOW64\cscript Hello.vbs
'
' This script makes no error checking at all and assumes that the
' SwissDecTX transmitter is already installed and properly configured
'
' The Microsoft XML Parser 6.0 must be installed!
'
' This sample demonstrate the use of the SwissDecTX.XmlUtilities class

wscript.Echo "Creating SwissDecTX.XmlUtilities object..."

Set xml = CreateObject("SwissDecTX.XmlUtilities")

wscript.Echo "Creating salary declaration..."

xml.CreateDoc "DeclareSalary", "http://www.swissdec.ch/schema/sd/20051002/SalaryDeclarationServiceTypes", "Schemas\SalaryDeclaration.xsd", "Schemas\SalaryDeclarationContainer.xsd", "Schemas\SalaryDeclarationServiceTypes.xsd"

xml.SetAttribute "xmlns:ct", "http://www.swissdec.ch/schema/sd/20051002/SalaryDeclarationContainer"
xml.SetAttribute "xmlns:sd", "http://www.swissdec.ch/schema/sd/20051002/SalaryDeclaration"
xml.SetAttribute "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"

xml.StartTag "ct:RequestContext"

    xml.StartTag "ct:UserAgent"
        xml.AddTextTag "ct:Producer", "itServe AG"
        xml.AddTextTag "ct:Name", "Test"
        xml.AddTextTag "ct:Version", "0.1"
        xml.AddTextTag "ct:Certificate", "None"
    xml.EndTag
    
    xml.StartTag "ct:CompanyName"
        xml.AddTextTag "sd:HR-RC-Name", "ICHAG"
    xml.EndTag
    
    xml.AddTextTag "ct:TransmissionDate", "2009-09-28T09:30:47.0Z"
    xml.AddTextTag "ct:RequestID", "1234"
    xml.AddTextTag "ct:LanguageCode", "fr"
    xml.AddTextTag "ct:MonitoringID", "tester"
    
xml.EndTag

xml.StartTag "ct:Job"

    xml.StartTag "ct:Addressees"
        xml.StartTag "ct:UVG-LAA"
            xml.SetAttribute "institutionIDRef", "#Suva"
            xml.AddBoolTag "ct:ProcessByDistributor", True
        xml.EndTag
    xml.EndTag
    
xml.EndTag

xml.StartTag "ct:SalaryDeclaration"

    xml.SetAttribute "schemaVersion", "0.0"
    xml.SetAttribute "xmlns", "http://www.swissdec.ch/schema/sd/20051002/SalaryDeclaration"
    
    xml.StartTag "Company"
    
        xml.StartTag "CompanyDescription"
            xml.StartTag "Name"
                xml.AddTextTag "HR-RC-Name", "ICHAG"
            xml.EndTag
            xml.StartTag "Address"
                xml.AddTextTag "Street", "Lnggassstrasse 26"
                xml.AddTextTag "Postbox", "690"
                xml.AddTextTag "ZIP-Code", "3000"
                xml.AddTextTag "City", "Bern 9"
            xml.EndTag
            xml.AddTextTag "UID-EHRA", "CH-645.1.234.567-3"
            xml.AddTextTag "BUR-REE-Number", "123435"
        xml.EndTag
        
        xml.StartTag "Staff"
            
            xml.StartTag "Person"
            
                xml.StartTag "Particulars"
                    xml.StartTag "Social-InsuranceIdentification"
                        xml.AddTextTag "AHV-AVS-Number", "123.45.178.128"
                    xml.EndTag
                    xml.AddTextTag "EmployeeNumber", "0100"
                    xml.AddTextTag "Lastname", "Balmer"
                    xml.AddTextTag "Firstname", "Fredi"
                    xml.AddTextTag "Sex", "M"
                    xml.AddTextTag "DateOfBirth", "1945-03-16"
                    xml.AddTextTag "Nationality", "CH"
                    xml.AddTextTag "CivilStatus", "married"
                    xml.StartTag "Address"
                        xml.AddTextTag "Street", "Lnggassstrasse 26"
                        xml.AddTextTag "Postbox", "690"
                        xml.AddTextTag "ZIP-Code", "3000"
                        xml.AddTextTag "City", "Bern"
                    xml.EndTag
                    xml.AddTextTag "ResidenceCanton", "ZG"
                xml.EndTag
                
                xml.StartTag "Work"
                    xml.AddIntTag "ActivityRate", 99
                    xml.AddTextTag "WorkplaceCanton", "BE"
                xml.EndTag
                
                xml.StartTag "AHV-AVS-Salaries"
                    xml.StartTag "AHV-AVS-Salary"
                        xml.SetAttribute "institutionIDRef", "#003.000"
                        xml.StartTag "AccountingTime"
                            xml.AddTextTag "from", "2008-01-01"
                            xml.AddTextTag "until", "2008-12-31"
                        xml.EndTag
                        xml.AddFixedRealTag "AHV-AVS-Income", 65000.00, 2
                        xml.AddFixedRealTag "ALV-AC-Income", 65000.00, 2
                    xml.EndTag
                xml.EndTag
                
                xml.StartTag "StatisticSalaries"
                    xml.StartTag "StatisticSalary"
                        xml.StartTag "Period"
                            xml.AddTextTag "from", "2008-01-01"
                            xml.AddTextTag "until", "2008-12-31"
                        xml.EndTag
                        xml.AddFixedRealTag "TotalHoursOfWork", 42, 2
                        xml.AddFixedRealTag "GrossEarnings", 48160, 2
                        xml.AddFixedRealTag "SocialContributions", 11657, 2
                        xml.AddFixedRealTag "Allowances", 2850, 2
                        xml.AddFixedRealTag "Overtime", 2368.7, 2
                        xml.AddFixedRealTag "Earnings13th", 3300, 2
                        xml.AddFixedRealTag "SpecialPayments", 5000, 2
                        xml.AddFixedRealTag "PaymentsByThird", 2160, 2
                        xml.AddFixedRealTag "LaborCost", 4800, 2
                        xml.AddFixedRealTag "ExtendedBenefits", 1321.3, 2
                        xml.AddTextTag "Education", "enterpriseEducation"
                        xml.AddTextTag "Skill", "qualified"
                        xml.AddTextTag "Position", "highestCadre"
                        xml.AddIntTag "Activity", 21
                        xml.AddTextTag "WageForm", "timeWages"
                    xml.EndTag
                
                xml.EndTag
            
            xml.EndTag
        
        xml.EndTag
        
        xml.StartTag "Insurances"
        
            xml.StartTag "AHV-AVS"
                xml.SetAttribute "institutionID", "#003.000"
                xml.AddTextTag "AK-CC-BranchNumber", "003.000"
                xml.AddTextTag "AK-CC-CustomerNumber", "100-9976.9"
            xml.EndTag
            
            xml.StartTag "UVG-LAA"
                xml.StartTag "Suva"
                    xml.SetAttribute "institutionID", "#Suva"
                    xml.AddTextTag "SuvaCustomerNumber", "302-15096.6"
                    xml.AddTextTag "SuvaSubNumber", "01"
                    xml.StartTag "Note"
                        xml.StartTag "IncompleteSalaryDeclaration"
                        xml.EndTag
                        xml.AddTextTag "Comments", "Spezielle Abmachung gemss Vertrag XYZ"
                    xml.EndTag
                xml.EndTag
            xml.EndTag

        xml.EndTag
        
        xml.StartTag "SalaryTotals"
            xml.StartTag "AHV-AVS-Totals"
                xml.SetAttribute "institutionIDRef", "#003.000"
                xml.AddFixedRealTag "Total-AHV-AVS-Incomes", 65000, 2
                xml.AddFixedRealTag "Total-AHV-AVS-Open", 0, 2
                xml.AddFixedRealTag "Total-ALV-AC-Incomes", 65000, 2
                xml.AddFixedRealTag "Total-ALVZ-ACS-Incomes", 0, 2
                xml.AddFixedRealTag "Total-ALV-AC-Open", 0, 2
            xml.EndTag
        xml.EndTag
        
        xml.StartTag "SalaryCounters"
            xml.AddIntTag "NumberOf-AHV-AVS-Salary-Tags", 1
            xml.AddIntTag "NumberOf-StatisticSalaries-Tags", 1
        xml.EndTag
        
        xml.StartTag "Statistic"
            xml.StartTag "CompanyWorkingTime"
                xml.AddFixedRealTag "WeeklyHours", 42, 2
            xml.EndTag
            xml.AddTextTag "PayAgreement", "individualContract"
        xml.EndTag

    xml.EndTag
    
    xml.StartTag "GeneralSalaryDeclarationDescription"
        xml.AddTextTag "CreationDate", "2009-09-28T14:14:00"
        xml.AddIntTag "AccountingPeriod", 2008
        xml.StartTag "ContactPerson"
            xml.AddTextTag "Name", "Marcel Ren Dupont"
            xml.AddTextTag "EmailAddress", "ichag@xxxxx.ch"
            xml.AddTextTag "PhoneNumber", "022 345 23 87"
        xml.EndTag
        xml.AddTextTag "Comments", "Some comment"
    xml.EndTag
    
xml.EndTag

' Run the XSD validation

wscript.Echo "Validating..."

xml.Validate

' Save document to disk

wscript.Echo "Writing to disk..."

xml.SaveAs "MySalaryDeclaration.xml", False

wscript.Echo "Cleaning up..."

xml.Cleanup

Set xml = Nothing

wscript.Echo "Done."

' 4 more lines to transmit declaration to SwissDec server

'Set tx = CreateObject("SwissDecTX.Transmitter")
'Dim jobFinished, transmissionDateTime
'tx.File2FileDeclareSalary "MySalaryDeclaration.xml", "result.xml", "messageSent.xml", "messageReceived.xml", "plausibility.xml", jobFinished, txDateTime
'Set tx = Nothing

' 3 lines to format the plausibility result as HTML for display

'Set xslt = CreateObject("SwissDecTX.TransmitterUtilities")
'xslt.ConvertFromFilesToFile "plausibility.xml", Nothing, "plausibility.html"
'Set xslt = Nothing

' and 3 last lines to lauch the default browser on the formatted plausibility result

'Set shell = WScript.CreateObject("WScript.Shell")
'shell.Run "plausibility.html", 1, false
'Set shell = Nothing
