// SwissDecTX.API.h - C-callable API for the SwissDecTX Transmitter 5.09
// Designed and written by Axel Rietschin. Copyright (c) 2009-2013, All rights reserved.
// Website: http://www.swissdectx.ch

#pragma once

#include <msxml.h>

#ifdef SWISSDECTX_EXPORTS
	#define SWISSDECTX_API extern "C" __declspec(dllexport) HRESULT
#else
	#pragma comment(lib, "SwissDecTX")
	#define SWISSDECTX_API extern "C" __declspec(dllimport) HRESULT
#endif

namespace SwissDecTX_API {

typedef enum tagCERTIFICATESEARCHMODE
{
    CertificateSearchMode_FindByThumbprint = 0,
    CertificateSearchMode_FindBySubjectName = 1,
    CertificateSearchMode_FindBySubjectDistinguishedName = 2,
    CertificateSearchMode_FindByIssuerName = 3,
    CertificateSearchMode_FindByIssuerDistinguishedName = 4,
    CertificateSearchMode_FindBySerialNumber = 5,
    CertificateSearchMode_FindByTimeValid = 6,
    CertificateSearchMode_FindByTimeNotYetValid = 7,
    CertificateSearchMode_FindByTimeExpired = 8,
    CertificateSearchMode_FindByTemplateName = 9,
    CertificateSearchMode_FindByApplicationPolicy = 10,
    CertificateSearchMode_FindByCertificatePolicy = 11,
    CertificateSearchMode_FindByExtension = 12,
    CertificateSearchMode_FindByKeyUsage = 13,
    CertificateSearchMode_FindBySubjectKeyIdentifier = 14
} CERTIFICATESEARCHMODE;

#define MIN_SWISSDEC_IDENTIFIER_BUFFER_LENGTH_CHARS	21

SWISSDECTX_API OpenTransmitter(LPHANDLE lphTX);
SWISSDECTX_API CloseTransmitter(HANDLE hTX);

SWISSDECTX_API LoadLicenseFileA(HANDLE hTX, LPSTR lpszLicensePathName);
SWISSDECTX_API LoadLicenseFileW(HANDLE hTX, LPWSTR lpszLicensePathName);

SWISSDECTX_API SetUrlA(HANDLE hTX, LPSTR lpszUrl);
SWISSDECTX_API SetUrlW(HANDLE hTX, LPWSTR lpszUrl);

SWISSDECTX_API SetCredentialsA(HANDLE hTX, LPSTR lpszUserName, LPSTR lpszPassword);
SWISSDECTX_API SetCredentialsW(HANDLE hTX, LPWSTR lpszUserName, LPWSTR lpszPassword);

SWISSDECTX_API SetHttpProxyA(HANDLE hTX, LPSTR lpszHost, DWORD dwPort);
SWISSDECTX_API SetHttpProxyW(HANDLE hTX, LPWSTR lpszHost, DWORD dwPort);

SWISSDECTX_API SetHttpProxyWithCredentialsA(HANDLE hTX, LPSTR lpszHost, DWORD dwPort, LPSTR lpszProxyUserName, LPSTR lpszProxyPassword);
SWISSDECTX_API SetHttpProxyWithCredentialsW(HANDLE hTX, LPWSTR lpszHost, DWORD dwPort, LPWSTR lpszProxyUserName, LPWSTR lpszProxyPassword);

SWISSDECTX_API SetEncryption(HANDLE hTX, BOOL encryptTransmissions);

SWISSDECTX_API SetReceiverCertificateA(HANDLE hTX, LPSTR lpszCertificateSearchString, CERTIFICATESEARCHMODE csm);
SWISSDECTX_API SetReceiverCertificateW(HANDLE hTX, LPWSTR lpszCertificateSearchString, CERTIFICATESEARCHMODE csm);

SWISSDECTX_API SetTransmitterCertificateA(HANDLE hTX, LPSTR lpszCertificateSearchString, CERTIFICATESEARCHMODE csm);
SWISSDECTX_API SetTransmitterCertificateW(HANDLE hTX, LPWSTR lpszCertificateSearchString, CERTIFICATESEARCHMODE csm);

SWISSDECTX_API SetSchemasLocationA(HANDLE hTX, LPSTR lpszSchemasPathName);
SWISSDECTX_API SetSchemasLocationW(HANDLE hTX, LPWSTR lpszSchemasPathName);

// -----------------------

SWISSDECTX_API Ping(HANDLE hTX, OUT DATE* lpServerTime);
SWISSDECTX_API PingStringA(HANDLE hTX, IN OUT LPSTR lpszServerTime, IN LCID nLcid);
SWISSDECTX_API PingStringW(HANDLE hTX, IN OUT LPWSTR lpszServerTime, IN LCID nLcid);

SWISSDECTX_API CheckInteroperabilityA(HANDLE hTX, LPSTR lpszMonitoringID);
SWISSDECTX_API CheckInteroperabilityW(HANDLE hTX, LPWSTR lpszMonitoringID);

SWISSDECTX_API CheckInteroperabilityWithOperandsA(HANDLE hTX, LPSTR lpszMonitoringID, DECIMAL decFirstOperand, DECIMAL decSecondOperand, OUT DECIMAL* lpcyAdditionResult, OUT DECIMAL* lpcySubtractionResult, IN OUT LPSTR lpszConstString, OUT DATE* lpServerTime);
SWISSDECTX_API CheckInteroperabilityWithOperandsW(HANDLE hTX, LPWSTR lpszMonitoringID, DECIMAL decFirstOperand, DECIMAL decSecondOperand, OUT DECIMAL* lpcyAdditionResult, OUT DECIMAL* lpcySubtractionResult, IN OUT LPWSTR lpszConstString, OUT DATE* lpServerTime);

SWISSDECTX_API CheckInteroperabilityWithStringOperandsA(HANDLE hTX, LPSTR lpszMonitoringID, LPSTR lpszFirstOperand, LPSTR lpszSecondOperand, OUT LPSTR lpszAdditionResult, OUT LPSTR lpszSubtractionResult, IN OUT LPSTR lpszConstString, OUT LPSTR lpszServerTime, IN LCID nLcid);
SWISSDECTX_API CheckInteroperabilityWithStringOperandsW(HANDLE hTX, LPWSTR lpszMonitoringID, LPWSTR lpszFirstOperand, LPWSTR lpszSecondOperand, OUT LPWSTR lpszAdditionResult, OUT LPWSTR lpszSubtractionResult, IN OUT LPWSTR lpszConstString, OUT LPWSTR lpszServerTime, IN LCID nLcid);

// -----------------------

SWISSDECTX_API File2FileDeclareSalaryA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszJobKey, DWORD cchJobKey, OUT DATE* lpTransmissionDateUtc);
SWISSDECTX_API File2FileDeclareSalaryW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszJobKey, DWORD cchJobKey, OUT DATE* lpTransmissionDateUtc);

SWISSDECTX_API File2FileDeclareSalaryLocalA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszResultFile, LPSTR lpszMessageCreatedAndCryptedFile, LPSTR lpszMessageCreatedFile, OUT DATE* lpCreationDateUtc);
SWISSDECTX_API File2FileDeclareSalaryLocalW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszResultFile, LPWSTR lpszMessageCreatedAndCryptedFile, LPWSTR lpszMessageCreatedFile, OUT DATE* lpCreationDateUtc);

SWISSDECTX_API File2FileGetStatusFromDeclareSalaryA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszJobKey, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszPlausibilityFile, LPBOOL lpJobFinished);
SWISSDECTX_API File2FileGetStatusFromDeclareSalaryW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszJobKey, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszPlausibilityFile, LPBOOL lpJobFinished);

SWISSDECTX_API File2FileGetResultFromDeclareSalaryA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszPlausibilityPathName, LPSTR lpszdomainString, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszDeclareSalaryResultFile);
SWISSDECTX_API File2FileGetResultFromDeclareSalaryW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszPlausibilityPathName, LPWSTR lpszdomainString, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszDeclareSalaryResultFile);

// -----------------------

#if IMPLEMENT_SYNCHRONIZE_CONTRACT

SWISSDECTX_API File2FileSynchronizeContractA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszJobKey, DWORD cchJobKey, OUT DATE* lpTransmissionDateUtc);
SWISSDECTX_API File2FileSynchronizeContractW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszJobKey, DWORD cchJobKey, OUT DATE* lpTransmissionDateUtc);

SWISSDECTX_API File2FileSynchronizeContractLocalA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszResultFile, LPSTR lpszMessageCreatedAndCryptedFile, LPSTR lpszMessageCreatedFile, OUT DATE* lpCreationDateUtc);
SWISSDECTX_API File2FileSynchronizeContractLocalW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszResultFile, LPWSTR lpszMessageCreatedAndCryptedFile, LPWSTR lpszMessageCreatedFile, OUT DATE* lpCreationDateUtc);

SWISSDECTX_API File2FileGetStatusFromSynchronizeContractA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszJobKey, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszPlausibilityFile, LPBOOL lpJobFinished);
SWISSDECTX_API File2FileGetStatusFromSynchronizeContractW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszJobKey, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszPlausibilityFile, LPBOOL lpJobFinished);

SWISSDECTX_API File2FileGetResultFromSynchronizeContractA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszPlausibilityPathName, LPSTR lpszDomainString, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszSynchronizeContractResultFile);
SWISSDECTX_API File2FileGetResultFromSynchronizeContractW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszPlausibilityPathName, LPWSTR lpszDomainString, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszSynchronizeContractResultFile);

#endif

SWISSDECTX_API File2FileGetDialogA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszPlausibilityPathName, LPSTR lpszdomainString, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszGetDialogResultFile);
SWISSDECTX_API File2FileGetDialogW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszPlausibilityPathName, LPWSTR lpszdomainString, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszGetDialogResultFile);

SWISSDECTX_API File2FileReplyDialogA(HANDLE hTX, LPSTR lpszSourceFilePathName, LPSTR lpszPlausibilityPathName, LPSTR lpszdomainString, LPSTR lpszMessagesFile, LPSTR lpszResultFile, LPSTR lpszMessageSentFile, LPSTR lpszMessageReceivedFile, LPSTR lpszReplyDialogResultFile);
SWISSDECTX_API File2FileReplyDialogW(HANDLE hTX, LPWSTR lpszSourceFilePathName, LPWSTR lpszPlausibilityPathName, LPWSTR lpszdomainString, LPWSTR lpszMessagesFile, LPWSTR lpszResultFile, LPWSTR lpszMessageSentFile, LPWSTR lpszMessageReceivedFile, LPWSTR lpszReplyDialogResultFile);

// -----------------------

SWISSDECTX_API InstallCertificatesA(HANDLE hTX, LPSTR lpszRootCertificatePathName, LPSTR lpszReceiverCertificatePathName, LPSTR lpszTransmitterCertificatePathName, LPSTR lpszPassword, BOOL fPerMachineInstallation);
SWISSDECTX_API InstallCertificatesW(HANDLE hTX, LPWSTR lpszRootCertificatePathName, LPWSTR lpszReceiverCertificatePathName, LPWSTR lpszTransmitterCertificatePathName, LPWSTR lpszPassword, BOOL fPerMachineInstallation);

SWISSDECTX_API CreateRequestIdA(HANDLE hTX, OUT LPSTR lpsz, int nBufferLengthChars);
SWISSDECTX_API CreateRequestIdW(HANDLE hTX, OUT LPWSTR lpsz, int nBufferLengthChars);

SWISSDECTX_API GetLastRequestIdA(HANDLE hTX, OUT LPSTR lpsz, int nBufferLengthChars);
SWISSDECTX_API GetLastRequestIdW(HANDLE hTX, OUT LPWSTR lpsz, int nBufferLengthChars);

SWISSDECTX_API GetLastResponseIdA(HANDLE hTX, OUT LPSTR lpsz, int nBufferLengthChars);
SWISSDECTX_API GetLastResponseIdW(HANDLE hTX, OUT LPWSTR lpsz, int nBufferLengthChars);

SWISSDECTX_API GetLastDeclarationIdA(HANDLE hTX, OUT LPSTR lpsz, int nBufferLengthChars);
SWISSDECTX_API GetLastDeclarationIdW(HANDLE hTX, OUT LPWSTR lpsz, int nBufferLengthChars);

// Utility API

SWISSDECTX_API XsltConvertFromFilesToFileA(LPSTR lpszXmlFile, LPSTR lpszStylesheetFile, LPSTR lpszOutputFile);
SWISSDECTX_API XsltConvertFromFilesToFileW(LPWSTR lpszXmlFile, LPWSTR lpszStylesheetFile, LPWSTR lpszOutputFile);

SWISSDECTX_API XsltConvertDataFromFilesToFileA(LPSTR lpszXmlFile, LPSTR lpszStylesheetFile, LPSTR lpszOutputFile);
SWISSDECTX_API XsltConvertDataFromFilesToFileW(LPWSTR lpszXmlFile, LPWSTR lpszStylesheetFile, LPWSTR lpszOutputFile);

// XML Bridge API

SWISSDECTX_API XmlCreateDocA(const char* lpszRoot, const char* lpszNamespaceURI, const char* lpszValidationSchema1, const char* lpszValidationSchema2, const char* lpszValidationSchema3);
SWISSDECTX_API XmlCreateDocW(const wchar_t* lpszRoot, const wchar_t* lpszNamespaceURI, const wchar_t* lpszValidationSchema1, const wchar_t* lpszValidationSchema2, const wchar_t* lpszValidationSchema3);

SWISSDECTX_API XmlCreateDocFromFileA(const char* lpszFile, const char* lpszValidationSchema1, const char* lpszValidationSchema2, const char* lpszValidationSchema3);
SWISSDECTX_API XmlCreateDocFromFileW(const wchar_t* lpszFile, const wchar_t* lpszValidationSchema1, const wchar_t* lpszValidationSchema2, const wchar_t* lpszValidationSchema3);

SWISSDECTX_API XmlSaveAsA(const char* lpszFile, BOOL fIndent);
SWISSDECTX_API XmlSaveAsW(const wchar_t* lpszFile, BOOL fIndent);

SWISSDECTX_API XmlCleanup ();

SWISSDECTX_API XmlGetLastErrorA(char* lpszOutputBuffer, unsigned int cch);
SWISSDECTX_API XmlGetLastErrorW(wchar_t* lpszOutputBuffer, unsigned int cch);

SWISSDECTX_API XmlValidate ();

SWISSDECTX_API XmlStartTagA(const char* lpszName);
SWISSDECTX_API XmlStartTagW(const wchar_t* lpszName);

SWISSDECTX_API XmlSetAttributeA(const char* lpszName, const char* lpszValue);
SWISSDECTX_API XmlSetAttributeW(const wchar_t* lpszName, const wchar_t* lpszValue);

SWISSDECTX_API XmlSetValueA(const char* lpszValue);
SWISSDECTX_API XmlSetValueW(const wchar_t* lpszValue);

SWISSDECTX_API XmlEndTag ();

SWISSDECTX_API XmlSelectNodeA(const char* lpszXPath);
SWISSDECTX_API XmlSelectNodeW(const wchar_t* lpszXPath);

SWISSDECTX_API XmlGetAttributeA(const char* lpszName, char* lpszOutputBuffer, unsigned int cch);
SWISSDECTX_API XmlGetAttributeW(const wchar_t* lpszName, wchar_t* lpszOutputBuffer, unsigned int cch);

SWISSDECTX_API XmlGetValueA(char* lpszOutputBuffer, unsigned int cch);
SWISSDECTX_API XmlGetValueW(wchar_t* lpszOutputBuffer, unsigned int cch);

SWISSDECTX_API XmlAddTextTagA(const char* lpszName, const char* lpszValue);
SWISSDECTX_API XmlAddTextTagW(const wchar_t* lpszName, const wchar_t* lpszValue);

SWISSDECTX_API XmlAddBoolTagA(const char* lpszName, BOOL fValue);
SWISSDECTX_API XmlAddBoolTagW(const wchar_t* lpszName, BOOL fValue);

SWISSDECTX_API XmlAddIntTagA(const char* lpszName, int nValue);
SWISSDECTX_API XmlAddIntTagW(const wchar_t* lpszName, int nValue);

SWISSDECTX_API XmlAddUnsignedTagA(const char* lpszName, unsigned int nValue);
SWISSDECTX_API XmlAddUnsignedTagW(const wchar_t* lpszName, unsigned int nValue);

SWISSDECTX_API XmlAddRealTagA(const char* lpszName, double dValue);
SWISSDECTX_API XmlAddRealTagW(const wchar_t* lpszName, double dValue);

SWISSDECTX_API XmlAddFixedRealTagA(const char* lpszName, double dValue, int nDecimals);
SWISSDECTX_API XmlAddFixedRealTagW(const wchar_t* lpszName, double dValue, int nDecimals);

#ifndef SWISSDECTX_EXPORTS

#ifdef UNICODE

// Transmitter API

#define LoadLicenseFile LoadLicenseFileW
#define SetUrl SetUrlW
#define SetCredentials SetCredentialsW
#define SetHttpProxy SetHttpProxyW
#define SetHttpProxyWithCredentials SetHttpProxyWithCredentialsW
#define SetReceiverCertificateSetReceiverCertificateW
#define SetTransmitterCertificate SetTransmitterCertificateW
#define SetSchemasLocation SetSchemasLocationW
#define PingString PingStringW
#define CheckInteroperability CheckInteroperabilityW
#define CheckInteroperabilityWithOperands CheckInteroperabilityWithOperandsW
#define CheckInteroperabilityWithStringsOperands CheckInteroperabilityWithStringsOperandsW
#define DeclareSalary File2FileDeclareSalaryW
#define DeclareSalaryLocal File2FileDeclareSalaryLocalW
#define GetStatusFromDeclareSalary File2FileGetStatusFromDeclareSalaryW
#define GetResultFromDeclareSalary File2FileGetResultFromDeclareSalaryW

#if IMPLEMENT_SYNCHRONIZE_CONTRACT

#define SynchronizeContract File2FileSynchronizeContractW
#define SynchronizeContractLocal File2FileSynchronizeContractLocalW
#define GetStatusFromSynchronizeContract File2FileGetStatusFromSynchronizeContractW
#define GetResultFromSynchronizeContract File2FileGetResultFromSynchronizeContractW

#endif

#define GetDialog File2FileGetDialogW
#define ReplyDialog File2FileReplyDialogW

#define InstallCertificates InstallCertificatesW
#define CreateRequestId CreateRequestIdW
#define GetLastRequestId GetLastRequestIdW
#define GetLastResponseId GetLastResponseIdW
#define GetLastDeclarationId GetLastDeclarationIdW

// Utility API

#define XsltConvertFromFilesToFile XsltConvertFromFilesToFileW
#define XsltConvertDataFromFilesToFile XsltConvertDataFromFilesToFileW

// XML Bridge API

#define XmlCreateDoc XmlCreateDocW
#define XmlCreateDocFromFile XmlCreateDocFromFileW
#define XmlSaveAs XmlSaveAsW
#define XmlGetLastError XmlGetLastErrorW
#define XmlStartTag XmlStartTagW
#define XmlSetAttribute XmlSetAttributeW
#define XmlSetValue XmlSetValueW
#define XmlSelectNode XmlSelectNodeW
#define XmlGetAttribute XmlGetAttributeW
#define XmlGetValue XmlGetValueW
#define XmlAddTextTag XmlAddTextTagW
#define XmlAddBoolTag XmlAddBoolTagW
#define XmlAddIntTag XmlAddIntTagW
#define XmlAddUnsignedTag XmlAddUnsignedTagW
#define XmlAddRealTag XmlAddRealTagW
#define XmlAddFixedRealTag XmlAddFixedRealTagW

#else /* !UNICODE */

// Transmitter API

#define LoadLicenseFile LoadLicenseFileA
#define SetUrl SetUrlA
#define SetCredentials SetCredentialsA
#define SetHttpProxy SetHttpProxyA
#define SetHttpProxyWithCredentials SetHttpProxyWithCredentialsA
#define SetReceiverCertificateSetReceiverCertificateA
#define SetTransmitterCertificate SetTransmitterCertificateA
#define SetSchemasLocation SetSchemasLocationA
#define PingString PingStringA
#define CheckInteroperability CheckInteroperabilityA
#define CheckInteroperabilityWithOperands CheckInteroperabilityWithOperandsA
#define CheckInteroperabilityWithStringsOperands CheckInteroperabilityWithStringsOperandsA
#define DeclareSalary File2FileDeclareSalaryA
#define DeclareSalaryLocal File2FileDeclareSalaryLocalA
#define GetStatusFromDeclareSalary File2FileGetStatusFromDeclareSalaryA
#define GetResultFromDeclareSalary File2FileGetResultFromDeclareSalaryA

#if IMPLEMENT_SYNCHRONIZE_CONTRACT

#define SynchronizeContract File2FileSynchronizeContractA
#define SynchronizeContractLocal File2FileSynchronizeContractLocalA
#define GetStatusFromSynchronizeContract File2FileGetStatusFromSynchronizeContractA
#define GetResultFromSynchronizeContract File2FileGetResultFromSynchronizeContractA

#endif

#define GetDialog File2FileGetDialogA
#define ReplyDialog File2FileReplyDialogA

#define InstallCertificates InstallCertificatesA
#define CreateRequestId CreateRequestIdA
#define GetLastRequestId GetLastRequestIdA
#define GetLastResponseId GetLastResponseIdA
#define GetLastDeclarationId GetLastDeclarationIdA

// Utility API

#define XsltConvertFromFilesToFile XsltConvertFromFilesToFileA
#define XsltConvertDataFromFilesToFile XsltConvertDataFromFilesToFileA

// XML Bridge API

#define XmlCreateDoc XmlCreateDocA
#define XmlCreateDocFromFile XmlCreateDocFromFileA
#define XmlSaveAs XmlSaveAsA
#define XmlGetLastError XmlGetLastErrorA
#define XmlStartTag XmlStartTagA
#define XmlSetAttribute XmlSetAttributeA
#define XmlSetValue XmlSetValueA
#define XmlSelectNode XmlSelectNodeA
#define XmlGetAttribute XmlGetAttributeA
#define XmlGetValue XmlGetValueA
#define XmlAddTextTag XmlAddTextTagA
#define XmlAddBoolTag XmlAddBoolTagA
#define XmlAddIntTag XmlAddIntTagA
#define XmlAddUnsignedTag XmlAddUnsignedTagA
#define XmlAddRealTag XmlAddRealTagA
#define XmlAddFixedRealTag XmlAddFixedRealTagA

#endif /* UNICODE */

#endif /* SWISSDECTX_EXPORTS */

} /* SwissDecTX_API */